class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'PC Magazine'
    oldest_article = 7
    max_articles_per_feed = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    remove_tags_before = dict(name='div', attrs={'class':'data-article'})
    remove_attributes = ['style', 'font']
    remove_tags = [
                   dict(name='div', attrs={'class':['container','agenda-bar xwide-tabs','content-bar','product-info','btn-holder','content-links','control-side','heading','comment','splashRibbon','top-header','agenda-bar narrow-tabs2']}),
                   dict(name='div', attrs={'id':['sidebar','pcmag-footer','footer','header','authorDrop']}),
                   dict(name='ul', attrs={'class':['subscribe-panel','item-list','breadcrumbs another','comment','illustration']}),
                   dict(name='ul', attrs={'id':['']}),
	dict(name='ol', attrs={'id':['']}),
                    dict(name='a', attrs={'class':['dsq-brlink','comments-login']}),
	dict(name='span', attrs={'class':['']}),
	dict(name='p', attrs={'class':'highlights_content'}),
                   dict(name=['img','script']),]

    feeds          = [(u'Media Hubs', u'http://feeds2.feedburner.com/ziffdavis/pcmag/mediahubs'),
                          (u'Breaking News', u'http://feeds2.feedburner.com/ziffdavis/pcmag/breakingnews'),
                          (u'Tips and Solutions', u'http://feeds2.feedburner.com/ziffdavis/pcmag/PCMagaineTips'),
                          (u'Windows Tips', u'http://feeds2.feedburner.com/ziffdavis/pcmag/officetips'),
                          (u'Commentary', u'http://feeds2.feedburner.com/ziffdavis/pcmag/commentary'),
                          (u'Reviews', u'http://feeds2.feedburner.com/ziffdavis/pcmag')
]
                       
						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
